﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
	<head>
		<title>Spis z natury</title>
		<script runat="server">
		
		public class ParametryBase : ContextBase {
		    public ParametryBase(Context cx) : base(cx) {
		    }
		    
		    private bool _zasoby = true;
		    
		    [Priority(10)]
		    [Caption("Zasoby")]
		    public bool Zasoby {
		        get { return _zasoby; }
		        set { _zasoby = value; OnChanged(EventArgs.Empty); }
		    }
		    
		    private bool _zamZRez = false;
		    
		    [Priority(20)]
		    [Caption("Zamówienia z rez.")]
		    public bool ZamZRez {
		        get { return _zamZRez; }
                set { _zamZRez = value; OnChanged(EventArgs.Empty); }
		    }
		    
		    private bool _rozchWBuf = false;
		    
		    [Priority(30)]
		    [Caption("Rozchody w buf.")]
		    public bool RozchWBuf {
		        get { return _rozchWBuf; }
                set { _rozchWBuf = value; OnChanged(EventArgs.Empty); }
		    }
		    
		    private Magazyn _magazyn;
		    
		    [Priority(40)]
		    [Caption("Magazyn")]
		    [Context]
		    public Magazyn Magazyn {
		        get { return _magazyn; }
		        set { _magazyn = value; OnChanged(EventArgs.Empty); }
		    }
		    
		}
		
		static ParametryBase parametry;
		
		[Context]
		public static ParametryBase Parametry {
		    get { return parametry; }
		    set { parametry = value; }
		}

        public class TotalTwr : IComparable {
            readonly Towar towar;
            StanMagazynuWorker smw = new StanMagazynuWorker();
            ObrotyTowaruWorker otw = new ObrotyTowaruWorker();
            Quantity stan = Quantity.Empty;
            decimal wartośćMagazynu = 0m;
            double cenaŚrednioważona = 0d;
            public TotalTwr(Towar towar, Date data) {
                this.towar = towar;
                if (data != Date.Empty && data != Date.Today) {
                    smw.Data = data;
                    otw.OkresCzasu = new FromTo(Date.MinValue, data);
                }
                smw.Towar = towar;
                otw.Towar = towar;
                if (Parametry.Magazyn != null) {
                    smw.Magazyn = Parametry.Magazyn;
                    otw.Magazyn = Parametry.Magazyn;
                }
                if (Parametry.Zasoby) {
                    stan += smw.StanMagazynu;
                    wartośćMagazynu += smw.WartośćMagazynu;
                }
                if (Parametry.ZamZRez) {
                    stan += smw.StanZamówieńMagazynowych;
                    wartośćMagazynu += smw.WartośćKsięgowaMagazynu - smw.WartośćMagazynu;
                }
                if (Parametry.RozchWBuf) {
                    stan += otw.IlośćRezerwacja;
                    wartośćMagazynu += otw.WartośćRozchoduRezerwacja;
                }
                cenaŚrednioważona = (double)wartośćMagazynu / stan.Value;
                cenaŚrednioważona = System.Math.Round(cenaŚrednioważona, 2);
                wartośćMagazynu = System.Math.Round(wartośćMagazynu, 2);
            }
            public Towar Towar {
                get { return towar; }
            }
            public Quantity Stan {
                get { return stan; }
            }
            public decimal WartośćMagazynu {
                get { return wartośćMagazynu; }
            }
            public double CenaŚrednioważona {
                get { return cenaŚrednioważona; }
            }
            public int CompareTo(object obj) {
                TotalTwr t = (TotalTwr)obj;
                return Towar.Kod.CompareTo(t.Towar.Kod);
            }
        }

        private bool TowarBezZasobów(Towar towar) {
            if (towar.Zasoby.IsEmpty) return true;
            foreach(Zasob zasob in towar.Zasoby.CreateView()) {
                if (!zasob.Zamkniety && zasob.Magazyn == Parametry.Magazyn)
                    return false;
            }
            return true;
        }

        protected void dc_ContextLoad(object sender, EventArgs e) {
            ObrotyParams param = (ObrotyParams)dc[typeof(ObrotyParams)];
            Date data = param != null && param.DataStanu != Date.Empty && param.DataStanu != Date.MaxValue
                        ? param.DataStanu
                        : Date.Today;
            
            string ustawienie = string.Empty;
            if (Parametry.Zasoby)
                ustawienie += "Zasoby";
            if (Parametry.ZamZRez) {
                if (Parametry.Zasoby)
                    ustawienie += ", ";
                ustawienie += "Zamówienia z rez.";
            }
            if (Parametry.RozchWBuf) {
                if (Parametry.Zasoby || Parametry.ZamZRez)
                    ustawienie += ", ";
                ustawienie += "Rozchody w buf.";
            }
            ReportHeader.Title +=
                string.Format("|Magazyn: {0} |Ustawienie: {1} |Data: {2}",
                              Parametry.Magazyn != null ? Parametry.Magazyn.ToString().Replace("&", "&amp;") : "(wszystkie)",
                              ustawienie,
                              data.ToString("yyyy-MM-dd"));
            
            Row[] towary = (Row[])dc[typeof(Row[])];
            Hashtable htTowary = new Hashtable();
            decimal wartość = 0m;
            foreach(Towar towar in towary) {
              //if (TowarBezZasobów(towar)) continue;
                TotalTwr t = (TotalTwr)htTowary[towar];
                if (t == null) {
                    t = new TotalTwr(towar, data);
                    if (t.WartośćMagazynu != 0m || !t.Stan.IsZero)
                        htTowary[towar] = t;
                }
                wartość += t.WartośćMagazynu;
            }
            ArrayList arrTowary = new ArrayList(htTowary.Values);
            arrTowary.Sort();
            Grid.DataSource = arrTowary;
            
            WartośćSłownie.EditValue =  new Currency(System.Math.Round(wartość, 2));
            dataLabelPosumowanie.EditValue = string.Format("Spis zakończono na pozycji {0}.", arrTowary.Count);
        }
        
</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</head>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Spis z natury"></eb:ReportHeader>
			<!--Wartość: Workers.StanMagazynu.WgCeny.Hurtowa.WartośćNetto lub Workers.StanMagazynu.WartośćMagazynu-->
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel">
				<Columns>
					<ea:GridColumn Width="6" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Towar" Caption="Towar" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Center" DataMember="Towar.Jednostka.Kod" Caption="Jm." Width="10" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" DataMember="Stan.Value" Caption="Ilość stwierdzona" Width="11" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" DataMember="CenaŚrednioważona" Caption="Cena" Format="{0:n}" Width="12" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" DataMember="WartośćMagazynu" Caption="Wartość" Width="12" Total="Sum" EncodeHTML="True"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<br />
			<table>
			    <tr>
			        <td>
			        <font size="2"><em>Wartość słownie: </em></font>
			        </td>
			        <td>
			            <font size="2"><ea:DataLabel runat="server" id="WartośćSłownie" Format="{0:+t}" Bold="false"></ea:DataLabel></font>
			        </td>
			    </tr>
			    <tr>
			        <td>
			        
			        </td>
			    </tr>
			</table>
			<br />
			<ea:DataLabel ID="dataLabelPosumowanie" runat=server> </ea:DataLabel>
			<br /><br />
			<em>
			Skład komisji inwentaryzacyjnej:<br />
			1. .................................................. podpis..............................<br />
			2. .................................................. podpis..............................<br />
			3. .................................................. podpis..............................<br />
			4. .................................................. podpis..............................<br />
			</em>
			<br />
			<em>
			Uwagi:<br />
			....................................................................................................<br />
			....................................................................................................<br />
			....................................................................................................<br />
			....................................................................................................<br />
			</em>
			<br />
			<eb:ReportFooter id="ReportFooter" runat="server">
			</eb:ReportFooter>
		</form>
	</body>
</html>

